package gov.va.genisis2.converter;

import static org.junit.Assert.assertEquals;
import static org.junit.Assert.assertTrue;

import java.util.ArrayList;
import java.util.List;

import org.junit.Before;
import org.junit.Test;

import gov.va.genisis2.AbstractMockMvcTests;
import gov.va.genisis2.dto.CommentHistoryDTO;
import gov.va.genisis2.model.CommentHistory;
import gov.va.genisis2.model.CommentType;
import gov.va.genisis2.util.DateUtil;
import gov.va.genisis2.util.Helper;

/**
 * @author Getaneh Kassahun
 */

public class CommentHistoryConverterTest extends AbstractMockMvcTests {

	private CommentHistoryConverter commentHistoryConverter;

	@Before
	public void setUp() {
		commentHistoryConverter = new CommentHistoryConverter();
	}

	@Test
	public void convert() {
		CommentHistory commentHistory = new CommentHistory();

		commentHistory.setRequest(Helper.getExistingRequest());
		commentHistory.setCommentId(1);
		commentHistory.setComments("comments");
		commentHistory.setCreatedOn(DateUtil.getTodaysDate());
		commentHistory.setCreatedBy("Admin");
		commentHistory.setCommentType(new CommentType());
		commentHistory.setRequestId(1);
		commentHistory.setStatus("Draft");
		commentHistory.setType("action");

		assertEquals("Draft", commentHistoryConverter.convert(commentHistory).getStatus());
	}

	@Test
	public void convert2() {
		CommentHistoryDTO commentHistoryDto = new CommentHistoryDTO();

		commentHistoryDto.setCommentId(1);
		commentHistoryDto.setRequestId(1);
		commentHistoryDto.setStatus("Draft");
		commentHistoryDto.setComments("Comments");
		commentHistoryDto.setCreatedBy("Admin");
		commentHistoryDto.setCommentType(1);

		assertEquals("Draft", commentHistoryConverter.convert(commentHistoryDto).getStatus());
	}

	@Test
	public void convertCommentHistories() {
		List<CommentHistory> commentHistoryDtos = new ArrayList<>();

		CommentHistory commentHistory = new CommentHistory();

		commentHistory.setRequest(Helper.getExistingRequest());
		commentHistory.setCommentId(1);
		commentHistory.setComments("comments");
		commentHistory.setCreatedOn(DateUtil.getTodaysDate());
		commentHistory.setCreatedBy("Admin");
		commentHistory.setCommentType(new CommentType());
		commentHistory.setRequestId(1);
		commentHistory.setStatus("Draft");
		commentHistory.setType("action");

		commentHistoryDtos.add(commentHistory);

		assertTrue(commentHistoryConverter.convertCommentHistories(commentHistoryDtos).size() > 0);

	}

}
